//
//  OnePasswordCoreConstants.h
//  OnePasswordCore
//
//  Created by Roustem Karimov on 2014-06-14.
//  Copyright (c) 2014 AgileBits. All rights reserved.
//

@import Foundation;
#import <stdint.h>

#if TARGET_OS_IPHONE
@import UIKit;
#else
@import Cocoa;
#endif

#if TARGET_OS_IPHONE
#define LIST_VIEW_ROW_HEIGHT 48.0f
#define DETAIL_VIEW_BACKGROUND_COLOR [UIColor whiteColor]
#if DEBUG
#define SUPPORT_EMAIL @[@"support+iosbeta@agilebits.com"]
#else
#define SUPPORT_EMAIL @[@"support+ios@agilebits.com"]
#endif	

#define SETTINGS_POPOVER_WIDTH 540.0f
#define SETTINGS_POPOVER_HEIGHT 620.0f
#endif

#define OPWatchtowerDatabaseName @"vuln"
#define OPPrefWatchtowerServiceEnabled @"watchtowerService"

#define OPPrefPasteboardClearTimeout @"PasteboardClearTimeout"
#define OPPrefEnablePasteboardClear @"EnablePasteboardClear"
#define OPPrefConcealPasswords @"ConcealPasswords"
#define OPPrefPasswordFont @"PasswordFont"
#define OPPrefShowRichIcons @"ShowRichIcons"
#define OPPrefEnableSpotlightSearch @"EnableSpotlightSearch"
#define OPPrefAutoSubmitLogins @"AutoSubmitLogins"
#define OPPrefAnimateFill @"AnimateFill"

#define OPPrefEnableAppleWatch @"OPPrefEnableAppleWatch"
#define OPPrefEnableAppleWatchPIN @"OPPrefEnableAppleWatchPIN"
#define OPPrefBadgeSettingsIconForMessageCenter @"OPPrefBadgeSettingsIconForMessageCenter"

#define OPPrefPromptToOpenURLs @"PromptToOpenURLs"

#define OPPrefAllowKeyboardExtensions @"AllowKeyboardExtensions"

#define OPPrefUbiquitySyncEnabled @"UbiquitySyncEnabled"

#define OPPrefLastFetchedNewsDate @"LastFetchedNewsDate"
#define OPPrefLastViewedNewsDate @"LastViewedNewsDate"

#define OPPrefLastFetchedVulnerabilitiesDate @"OPPrefLastFetchedVulnerabilitiesDate"

#define OPPrefPasswordRecipeVisible @"PasswordRecipeVisible"

#define OPPrefUserMessageReadStatus @"OPUserMessageReadStatusDefaultsKey"
#define OPPrefUserMessagePendingMessageIds @"OPUserMessagePendingIdsDefaultsKey"
#define OPPrefUserMessageHttpOrHttpsPublishedKey @"OPPrefUserMessageHttpOrHttpsPublishedKey"

#define OPPrefTroubleshootingEnabled @"TroubleshootingEnabled"
#define OPPrefLogSQLite @"LogSQLite"
#define OPPrefLogDatabase @"LogDatabase"
#define OPPrefLogKeychain @"LogKeychain"
#define OPPrefLogAgileKeychain @"LogAgileKeychain"
#define OPPrefLogCloudKeychain @"LogCloudKeychain"
#define OPPrefLogDropbox @"LogDropbox"
#define OPPrefLogReplicator @"LogReplicator"
#define OPPrefLogApp @"LogApp"
#define OPPrefLogSync @"LogSync"
#define OPPrefLogSearch @"LogSearch"
#define OPPrefLogCrypto @"LogCrypto"
#define OPPrefLogImageService @"LogImageService"
#define OPPrefLogWeb @"LogWeb"
#define OPPrefLogUI @"LogUI"
#define OPPrefLogUILock @"LogUILock"
#define OPPrefLogLock @"OPPrefLogLock"
#define OPPrefLogUIFavs @"LogUIFavs"
#define OPPrefLogUICategories @"LogUICategories"
#define OPPrefLogUIItems @"LogUIItems"
#define OPPrefLogStore @"LogStore"
#define OPPrefLogWatch @"LogWatch"
extern NSString *const OPPrefLogUtils;

#define OPPrefBackupEnabled @"BackupEnabled"
#define OPPrefBackupFrequency @"BackupFrequency"
#define OPPrefBackupFilesToKeep @"BackupFilesToKeep"
#define OPPrefBackupCleanedUpAutomaticBackups @"BackupCleanedUpAutomaticBackups"

FOUNDATION_EXPORT NSString * const OPPrefNewsletterSignupKey;
FOUNDATION_EXPORT NSString * const OPPrefNewsletterSkippedSignupKey;
FOUNDATION_EXPORT NSString * const OPPrefWiFiSyncSecondaryProfileUUIDs;


// Mac only
#define OPPrefLogWiFiSync @"LogWiFiSync"
#define OPPrefLogXPC @"LogXPC"
#define OPPrefLogMacUtils @"LogUtils"
#define OPPrefLogMacHelper @"LogHelper"
#define OPPrefLogMacHelperHotKeys @"LogHelperHotKeys"

#define OPPrefLogBackup @"LogBackup"
#define OPPrefLogExt @"LogExt"
#define OPPrefLogExtUI @"LogExtUI"
#define OPPrefLogBrain @"LogBrain"
#define OPPrefLogExport @"LogExport"
#define OPPrefLogImport @"LogImport"
#define OPPrefLogPrint @"LogPrint"

//#define UBIQUITY_CONTAINER_NAME_RELEASE @"2BUA8C4S2C.com.agilebits.onepassword"
//#define UBIQUITY_CONTAINER_NAME_PUBLIC_BETA @"8RS32JY83C.com.agilebits.beta.onepassword"
#define UBIQUITY_CONTAINER_NAME_RELEASE @"2BUA8C4S2C.com.agilebits.onepassword"
#define UBIQUITY_CONTAINER_NAME_PUBLIC_BETA @"8RS32JY83C.com.agilebits.beta.onepassword"

typedef enum  {
	OPUbiquityContainerTypeRelease = 1,
	OPUbiquityContainerTypeBeta = 2
} OPUbiquityContainerType;


#define OPPrefLastPromptDate @"LastPromptDate"
#define OPPrefNumberOfLaunches @"NumberOfLaunches"

#define settingAutosaveBlacklist @"autosaveBlacklist"

#define OPPrefIncludeLogsWithCrashReports @"IncludeLogsWithCrashReports"

FOUNDATION_EXPORT NSString *OPPrefSyncMonitorSettingsPrefix;
FOUNDATION_EXPORT NSString *OPPrefSyncMonitorStatsPrefix;
FOUNDATION_EXPORT NSString *OPPrefSyncMonitorWiFiSyncRemoteProfileAttributesPrefix;
FOUNDATION_EXPORT NSString *OPPrefWiFiSyncerTransportSecretPrefix;

#define OPPrefSearchScopeAllFields @"SearchScopeAllFields"

// Moved from OSXConstants
#define OPPrefAdvancedHashSectionIsSortedFirst @"HashSectionIsSortedFirst"

#define MAX_DROPBOX_CONNECTIONS_FOR_ITEMS 4
#define MAX_DROPBOX_CONNECTIONS_FOR_ITEMS_SH 2
#define MAX_DROPBOX_CONNECTIONS_FOR_ATTACHMENTS 2
#define MAX_DROPBOX_CONNECTIONS_FOR_ATTACHMENTS_SH 1

#define MAX_ITERATIONS_FOR_TABLE_ANIMATION 5000

#define DEMO_PASSWORD @"demo"

#define SWIPE_ANIMATION_DURATION 0.250
#define LIST_VIEW_REFRESH_INTERVAL 4.0
#define LIST_VIEW_REFRESH_INTERVAL_SLOW 12.0

#define EXPEDITED_SYNC_DELAY (2ull * NSEC_PER_SEC)
#define REGULAR_SYNC_INTERVAL (5ull * 60 * NSEC_PER_SEC)
#define SYNC_LEEWAY (1ull * NSEC_PER_SEC)

#define INITIAL_DROPBOX_DELAY (5ull * NSEC_PER_SEC)
#define REGULAR_DROPBOX_INTERVAL (1ull * 30 * NSEC_PER_SEC)
#define DROPBOX_LEEWAY (1ull * NSEC_PER_SEC)

typedef enum {
	OPSyncAnalysisVerdictUnknown = 0,
	OPSyncAnalysisVerdictNoChanges,
	OPSyncAnalysisVerdictCreateLocal,
	OPSyncAnalysisVerdictReplaceLocal,
	OPSyncAnalysisVerdictReplaceSource,
	OPSyncAnalysisVerdictConflictChooseLocal,
	OPSyncAnalysisVerdictConflictChooseSource,
	OPSyncAnalysisVerdictNonAuthenticSource,
	OPSyncAnalysisVerdictTrashAndExportLocalFolder,
	OPSyncAnalysisVerdictReplaceLocalTombstoneWithTrashedFolder,
	OPSyncAnalysisVerdictFailure = 99999
} OPSyncAnalysisVerdict;


typedef signed long long OPTimeInterval;
typedef unsigned long long OPTimestamp;
#define CURRENT_OPTIMESTAMP ((OPTimestamp)[[NSDate date] timeIntervalSince1970])

typedef uint64_t OPID;

#define MAX_DISPLAY_ORDER (INT32_MAX - 1)

// used on both iOS and OSX
#define OPKeychainLocationDropbox @"Dropbox"
#define OPKeychainLocationUbiquityContainer @"iCloud"

// A workaround for the bug in 1Password 3. This will still launch 1Password but prevent it from treating it as a Safari URL.
#define URL_IMPORT_FROM_V3 [NSURL URLWithString:@"onepassword3:/"]

#define OPItemSpecifierPboardType @"com.agilebits.onepassword.OPItemSpecifier"

#define kExistingBackupsFileNameKey @"filename"
#define kExistingBackupsFilePathKey @"fileURLPath"
#define kExistingBackupsFileSizeKey @"fileSize"
#define kExistingBackupsItemCountKey @"itemCount"
#define kExistingBackupsFolderCountKey @"folderCount"
#define kExistingBackupsAttachmentCountKey @"attachmentCount"
#define kExistingBackupsCreatedAtKey @"createdAt"

#if DEBUG
#define ENSURE_UI_THREAD if (![[NSThread currentThread] isMainThread]) log_assert(@"UI operations must be performed on the main thread. They crave the main thread. You want the UI to be happy, don't you? This message was brought to you by the UIView General Consel For Mainthreadedness.");
#define ENSURE_NOT_UI_THREAD if ([[NSThread currentThread] isMainThread]) log_error(@"\n***This shouldn't be ran on the main thread. This message was brought to you by Families For Responsive UIs.***\n");
#else
#define ENSURE_UI_THREAD do {} while (0);
#define ENSURE_NOT_UI_THREAD do {} while (0);
#endif

#if TARGET_OS_IPHONE
typedef UIImage OPImage;
typedef UIColor OPColor;
typedef CGSize  OPSize;

#define __iPad__ (UI_USER_INTERFACE_IDIOM() == UIUserInterfaceIdiomPad)
#define __iPhone__ (UI_USER_INTERFACE_IDIOM() == UIUserInterfaceIdiomPhone)
#else
typedef NSImage OPImage;
typedef NSColor OPColor;
typedef NSSize  OPSize;

#endif

#define NSSTRING_CONST_PUBLIC(KEY) NSString *const KEY = @#KEY
#define NSSTRING_CONST_EXTERN(KEY) extern NSString *const KEY
#define NSSTRING_CONST_PRIVATE(KEY) static NSString *const KEY = @#KEY

#define CGFLOAT_CONST_PUBLIC(KEY, VALUE) CGFloat const KEY = VALUE
#define CGFLOAT_CONST_EXTERN(KEY) extern CGFloat const KEY
#define CGFLOAT_CONST_PRIVATE(KEY, VALUE) static CGFloat const KEY = VALUE

#define NSINTEGER_CONST_PUBLIC(KEY, VALUE) NSInteger const KEY = VALUE
#define NSINTEGER_CONST_EXTERN(KEY) extern NSInteger const KEY
#define NSINTEGER_CONST_PRIVATE(KEY, VALUE) static NSInteger const KEY = VALUE

typedef NS_ENUM(NSUInteger, OPApplicationMode) {
	OPApplicationModeSetupRequired = 0,
	OPApplicationModeB5Standalone = 1,
	OPApplicationModeB5AndOP4 = 2,
};



FOUNDATION_EXPORT NSUInteger const OPMaximumFilesizeForUpload;

#pragma mark - OPXPCServer Keys

FOUNDATION_EXPORT NSString * const OPXPCAllObjectsForProfileAllItemsKey;// = @"allItems"
FOUNDATION_EXPORT NSString * const OPXPCAllObjectsForProfileCategoriesKey;// = @"categories"
FOUNDATION_EXPORT NSString * const OPXPCAllObjectsForProfileFoldersKey;// = @"folders"
FOUNDATION_EXPORT NSString * const OPXPCAllObjectsForProfileTagsKey;// = @"tags"
FOUNDATION_EXPORT NSString * const OPXPCAllObjectsForProfileFavoritesCountKey;// = @"favoritesCount"
FOUNDATION_EXPORT NSString * const OPXPCAllObjectsForProfileTrashKey; // = @"trash"

#pragma mark - OPVault Usage

FOUNDATION_EXPORT BOOL const OPDefaultValueForOPVaultPreference;
FOUNDATION_EXPORT NSString * const OPDefaultOPVaultUsageMigrationKey;

#pragma mark - License Info Keys

FOUNDATION_EXPORT NSString * const OPLicenseInfoIsPremiumKey;

// App Store Keys
FOUNDATION_EXPORT NSString * const OPLicenseInfoPurchasedFromAppStoreKey;

// Web Store Keys
FOUNDATION_EXPORT NSString * const OPLicenseInfoEmailKey;
FOUNDATION_EXPORT NSString * const OPLicenseInfoLicenseUUIDKey;
FOUNDATION_EXPORT NSString * const OPLicenseInfoNameKey;
FOUNDATION_EXPORT NSString * const OPLicenseInfoOrderDateKey;
FOUNDATION_EXPORT NSString * const OPLicenseInfoOrderNumberKey;
FOUNDATION_EXPORT NSString * const OPLicenseInfoProductNameKey;
FOUNDATION_EXPORT NSString * const OPLicenseInfoSeatsKey;
FOUNDATION_EXPORT NSString * const OPLicenseInfoSignatureKey;

// Web Store Product Names
FOUNDATION_EXPORT NSString * const OPLicenseProductName1Password4ForMac;
